# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

import sd
from .sdapiobject import SDAPIObject
from .sdarray import SDArray
from .sdresource import SDResource
from .sdapiobject import SDApiError
from .sdresource import EmbedMethod
from .apiexception import APIException

class SDResourceFolder(SDResource):
    """
    Folder (or group) of SDResource in a SDPackage
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDResourceFolder
        """
        super(SDResourceFolder, self).__init__(APIContext, handle, *args, **kwargs)

    @staticmethod
    def sNew(parent : SDAPIObject) -> SDResourceFolder:
        """
        Create a new SDResourceFolder under the specified parent

        :param parent: The parent data that will contains the newly created Resource. Can be SDPackage or SDResourceFolder
        """
        outResource = ctypes.c_void_p()
        _res = sd.getContext().SDResourceFolder_sNew(parent.mHandle, ctypes.byref(outResource))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = sd.getContext().mTypeMap[SDAPIObject(sd.getContext(), outResource, ownHandle=False).getClassName()]
        return constructor(sd.getContext(), outResource.value, ownHandle=True)

    def getChildren(self, isRecursive : bool) -> SDArray[SDResource]:
        """
        Retrieve resources under the current folder

        :param isRecursive: If True then all resources at all levels are flattened in 'outArray', otherwise only the direct children of the folder are retrieved
        """
        outArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDResourceFolder_getChildren(self.mHandle, isRecursive, ctypes.byref(outArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outArray.value, ownHandle=True)

